---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Thread Pool Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestThreadPoolAction.java` 行75-336
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行7

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cat/thread_pool と GET /_cat/thread_pool/{patterns} | E-01 行81 | ○ |
| C-02 | 3段階の非同期API呼び出し | E-01 行96-131 | ○ |
| C-03 | デフォルト表示カラム5個（node_name, name, active, queue, rejected） | E-01 行150,157,159,161,163 | ○ |
| C-04 | FORK_JOIN タイプの特別処理 | E-01 行193,204-219 | ○ |
| C-05 | SCALING タイプの core/max 表示 | E-01 行234-236 | ○ |
| C-06 | FIXED タイプの size 表示 | E-01 行239-240 | ○ |
| C-07 | TreeMap でスレッドプール名をソート | E-01 行298 | ○ |
| C-08 | Regex.simpleMatch でパターンマッチング | E-01 行281 | ○ |
| C-09 | thread_pool_patterns のデフォルトは "*" | E-01 行266 | ○ |
| C-10 | queue_size が null の場合 -1 | E-01 行250 | ○ |
| C-11 | writeRow がパッケージプライベート | E-01 行180 | ○ |
| C-12 | parallelism カラムは fork_join のみ有効 | E-01 行219,259 | ○ |
| C-13 | NodesInfoRequest で PROCESS と THREAD_POOL を指定 | E-01 行110-111 | ○ |
| C-14 | NodesStatsRequest で THREAD_POOL を指定 | E-01 行117 | ○ |
| C-15 | total_wait_time カラム | E-01 行166-169 | ○ |
| C-16 | 帳票一覧での定義内容 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの裏付けあり

## 6) レビュアーチェックリスト（最小）
- [ ] FORK_JOIN タイプの特別処理がソースコードと一致しているか
- [ ] SCALING/FIXED のcore/max/size表示の条件分岐が正確か
- [ ] デフォルト表示カラム5個が正しいか
